//
//  CRBorderAdapter.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 3/25/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRImageProcessor.h"

extern NSString* const CRBorderAdapterDoClipKey;
extern NSString* const CRBorderAdapterAngleKey;
extern NSString* const CRBorderAdapterSizeKey;
extern NSString* const CRBorderAdapterOverlapKey;
extern NSString* const CRBorderAdapterSideKey;
extern NSString* const CRBorderAdapterAutoImageKey;

//////////////////////////////////////////////////////////////////////
// Similar to CRFrameAdapter, but is intended to be used for borders:
// 
// COMMENT:
// NSCoding support does not encode images!
//////////////////////////////////////////////////////////////////////
typedef enum {
	CRBorderSideLeft	= 0,
	CRBorderSideRight	= 1,
	CRBorderSideTop		= 2,
	CRBorderSideBottom	= 3,
} CRBorderSide;

@interface CRBorderAdapter : CRImageProcessor
{
}

@property (nonatomic, assign) BOOL			doClip;		// signals whether corner clip is required
@property (nonatomic, assign) CGFloat		angle;		// input texture rotation angle
@property (nonatomic, assign) CGFloat		size;		// border size value [0, 1]
@property (nonatomic, assign) CGFloat		overlap;	// overlap value [0, 1]
@property (nonatomic, assign) CRBorderSide	side;		// selected border side
@property (nonatomic, copy)	  CIImage*		autoImage;	// adapter will adjust all params with this image: origin, size, crop etc.

@end